package com.ejie.aa17a.service.iface;

import java.math.BigDecimal;
import java.util.List;

import com.ejie.aa17a.model.Aa17aDatoHistorico;

/**
 * Aa17aDatoHistoricoService generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

public interface Aa17aDatoHistoricoService {

	/**
	 * Devuelve los datos historicos para cargar el grafico
	 * 
	 * @param aa17aDatoHistorico
	 *            Aa17aDatoHistorico
	 * @return List<BigDecimal[]>
	 */
	List<BigDecimal[]> getDatosHistorico(Aa17aDatoHistorico aa17aDatoHistorico);

	/**
	 * Devuelve el máximo idBanda del dia anterior al actual de los datos
	 * historicos de una estacion
	 * 
	 * @param idEstacion
	 *            Long
	 * @return Long
	 */
	Long getMaxIdBandaEstacion(Long idEstacion);

	/**
	 * Devuelve el idBanda del dia anterior al actual de los datos historicos de
	 * una estacion y un contaminante
	 * 
	 * @param datoHistorico
	 *            Aa17aDatoHistorico
	 * @return Long
	 */
	Long getIdBandaContaminante(Aa17aDatoHistorico datoHistorico);

	/**
	 * Devuelve los datos historicos en una lista de beans
	 * 
	 * @param aa17adatohistorico
	 *            Aa17aDatoHistorico
	 * @return List<Aa17aDatoHistorico>
	 */
	List<Aa17aDatoHistorico> listDatosHistoricos(Aa17aDatoHistorico aa17adatohistorico);

}
